/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.ui.config.controller;

import frc.emul.config.data.CfgItemCurve;
import frc.emul.periph.joystick.JInputJoystick;
import frc.emul.util.maths.CatmullRom;
import frc.emul.vectrex.ui.config.UIUtils;
import frc.emul.vectrex.ui.config.controller.UICalibrationGrid;
import frc.emul.vectrex.ui.config.controller.UIJInputConstants;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;

class UIResponseCurve
extends MouseInputAdapter
implements ActionListener {
    private final int RADIUS_POINT_DRAW = 3;
    private final int RADIUS_POINT_SEL = 4;
    private final Insets insets = new Insets(0, 0, 0, 0);
    private final int radius;
    private final int dX;
    private final int dY;
    private final JComponent canvas;
    private final UICalibrationGrid mapGrid;
    private final UICalibrationGrid rawGrid;
    private final JInputJoystick joystick;
    private JComponent panel;
    private JComboBox cbPoints;
    private JCheckBox chkEdit;
    private Point2D.Float[] points;
    private Point2D.Float[] workPoints;
    private Point2D.Float workPoint = new Point2D.Float();
    private int dragIndex = -1;

    UIResponseCurve(int n, CfgItemCurve cfgItemCurve, JInputJoystick jInputJoystick, UICalibrationGrid uICalibrationGrid, UICalibrationGrid uICalibrationGrid2) {
        this.joystick = jInputJoystick;
        this.mapGrid = uICalibrationGrid2;
        this.rawGrid = uICalibrationGrid;
        this.radius = n;
        this.canvas = this.createCurveComp();
        this.loadCurve(cfgItemCurve);
        this.updateCalibration(true, cfgItemCurve);
        this.canvas.addMouseListener(this);
        this.canvas.addMouseMotionListener(this);
        this.canvas.setCursor(Cursor.getPredefinedCursor(1));
        Insets insets = this.canvas.getInsets();
        this.dX = insets.left;
        this.dY = insets.top;
    }

    final void loadCurve(CfgItemCurve cfgItemCurve) {
        List<Point2D.Float> list = cfgItemCurve.getPoints();
        int n = Math.max(1, Math.min(4, list == null ? 0 : list.size()));
        Point2D.Float[] floatArray = new Point2D.Float[2 + n];
        floatArray[0] = new Point2D.Float(-1.0f, -1.0f);
        floatArray[n + 1] = new Point2D.Float(1.0f, 1.0f);
        if (list == null || list.isEmpty()) {
            floatArray[1] = new Point2D.Float(0.0f, 0.0f);
        } else {
            int n2 = n;
            while (n2-- > 0) {
                Point2D.Float float_ = list.get(n2);
                floatArray[n2 + 1] = new Point2D.Float(float_.x * 2.0f - 1.0f, float_.y * 2.0f - 1.0f);
            }
        }
        this.cbPoints.removeActionListener(this);
        this.cbPoints.setSelectedIndex(n - 1);
        this.cbPoints.addActionListener(this);
        this.points = floatArray;
        this.workPoints = null;
        this.setEnabled(cfgItemCurve.isActive());
        this.repaint();
    }

    final void saveCurve(CfgItemCurve cfgItemCurve) {
        List<Point2D.Float> list = cfgItemCurve.getPoints();
        Point2D.Float[] floatArray = this.points;
        list.clear();
        int n = 1;
        while (n < floatArray.length - 1) {
            Point2D.Float float_ = floatArray[n];
            list.add(new Point2D.Float((float_.x + 1.0f) / 2.0f, (float_.y + 1.0f) / 2.0f));
            ++n;
        }
        cfgItemCurve.setActive(this.isEnabled());
    }

    final CfgItemCurve getCurve() {
        CfgItemCurve cfgItemCurve = new CfgItemCurve();
        this.saveCurve(cfgItemCurve);
        return cfgItemCurve;
    }

    final JComponent getComponent() {
        return this.panel;
    }

    final void setEnabled(boolean bl) {
        boolean bl2 = this.joystick.isAnalogX() || this.joystick.isAnalogY();
        this.chkEdit.removeActionListener(this);
        this.chkEdit.setSelected(bl &= bl2);
        this.chkEdit.addActionListener(this);
        this.chkEdit.setEnabled(bl2);
        this.chkEdit.setToolTipText(bl2 ? null : "<html> The response curve can be edited for <b>analog</b> controls only. </html>");
        this.canvas.setToolTipText(this.chkEdit.getToolTipText());
        this.cbPoints.setToolTipText(this.chkEdit.getToolTipText());
        this.canvas.setEnabled(bl);
        this.rawGrid.setEnabled(bl);
        this.cbPoints.setEnabled(bl);
    }

    final boolean isEnabled() {
        return this.canvas.isEnabled();
    }

    final void repaint() {
        this.canvas.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.cbPoints) {
            this.handleComboBoxAction();
        } else if (object == this.chkEdit) {
            this.handleCheckBoxAction();
        }
    }

    private void handleCheckBoxAction() {
        this.setEnabled(this.chkEdit.isSelected());
        this.updateCalibration(true, null);
    }

    private void handleComboBoxAction() {
        int n = this.cbPoints.getSelectedIndex();
        if (this.points != null && this.points.length == n + 3) {
            return;
        }
        CfgItemCurve cfgItemCurve = new CfgItemCurve();
        List<Point2D.Float> list = cfgItemCurve.getPoints();
        switch (n) {
            case 0: {
                list.add(new Point2D.Float(0.5f, 0.5f));
                break;
            }
            case 1: {
                list.add(new Point2D.Float(0.25f, 0.25f));
                list.add(new Point2D.Float(0.75f, 0.75f));
                break;
            }
            case 2: {
                list.add(new Point2D.Float(0.25f, 0.25f));
                list.add(new Point2D.Float(0.5f, 0.5f));
                list.add(new Point2D.Float(0.75f, 0.75f));
                break;
            }
            case 3: {
                list.add(new Point2D.Float(0.125f, 0.125f));
                list.add(new Point2D.Float(0.375f, 0.375f));
                list.add(new Point2D.Float(0.625f, 0.625f));
                list.add(new Point2D.Float(0.875f, 0.875f));
            }
        }
        cfgItemCurve.setActive(true);
        this.loadCurve(cfgItemCurve);
        this.updateCalibration(true, cfgItemCurve);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.dragIndex >= 0) {
            Point2D.Float float_ = this.points[this.dragIndex];
            float f = (float)(mouseEvent.getX() - this.dX - this.radius) / (float)this.radius;
            float f2 = (float)(this.radius + this.dY - mouseEvent.getY()) / (float)this.radius;
            float_.x = Math.max(-1.0f, Math.min(1.0f, f));
            float_.y = Math.max(-1.0f, Math.min(1.0f, f2));
            this.updateCalibration(false, null);
            this.canvas.repaint();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.canvas.isEnabled()) {
            this.canvas.requestFocus();
            if (mouseEvent.getButton() != 1) {
                return;
            }
            this.dragIndex = this.getIndexOfPointAt(mouseEvent.getX() - this.dX, mouseEvent.getY() - this.dY);
            if (-1 != this.dragIndex) {
                this.setCursor(1);
                this.setTrackingEnabled(false);
                this.canvas.repaint();
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.canvas.isEnabled()) {
            if (-1 != this.getIndexOfPointAt(mouseEvent.getX() - this.dX, mouseEvent.getY() - this.dY)) {
                this.setCursor(0);
            } else {
                this.setCursor(1);
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() != 1) {
            return;
        }
        if (this.dragIndex >= 0) {
            this.mouseMoved(mouseEvent);
            this.dragIndex = -1;
            this.updateCalibration(true, null);
            this.setTrackingEnabled(true);
            this.canvas.repaint();
        }
    }

    private final void setCursor(int n) {
        this.canvas.setCursor(Cursor.getPredefinedCursor(n));
    }

    private final void setTrackingEnabled(boolean bl) {
        this.rawGrid.setTrackingEnabled(bl);
        this.mapGrid.setTrackingEnabled(bl);
    }

    private void updateCalibration(boolean bl, CfgItemCurve cfgItemCurve) {
        if (cfgItemCurve == null) {
            cfgItemCurve = this.getCurve();
        }
        if (bl) {
            this.joystick.setResponse(cfgItemCurve);
        }
        this.rawGrid.updateCalibration(cfgItemCurve);
    }

    private int getIndexOfPointAt(int n, int n2) {
        int n3 = n - this.radius;
        int n4 = this.radius - n2;
        int n5 = this.points.length - 1;
        while (n5-- > 1) {
            int n6;
            int n7 = (int)(this.points[n5].x * (float)this.radius);
            if (n3 < n7 - 4 || n3 > n7 + 4 || n4 < (n6 = (int)(this.points[n5].y * (float)this.radius)) - 4 || n4 > n6 + 4) continue;
            return n5;
        }
        return -1;
    }

    private void render(Graphics2D graphics2D, JComponent jComponent) {
        int n;
        int n2 = this.radius;
        boolean bl = this.isEnabled();
        Insets insets = jComponent.getInsets(this.insets);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(bl ? UIJInputConstants.COLOR_CURVE_BGND : jComponent.getParent().getBackground());
        graphics2D.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        graphics2D.translate(insets.left, insets.top);
        graphics2D.setColor(bl ? Color.DARK_GRAY : UIJInputConstants.COLOR_GRIDS_OFF);
        int n3 = 8;
        int n4 = 2 * n2;
        int n5 = 0;
        while (n5 <= n3) {
            n = n5 * (n2 * 2) / n3;
            graphics2D.drawLine(0, n, n4, n);
            graphics2D.drawLine(n, 0, n, n4);
            ++n5;
        }
        if (!this.isEnabled()) {
            graphics2D.translate(-insets.left, -insets.top);
            return;
        }
        graphics2D.setColor(Color.YELLOW);
        this.drawCubicCurve(graphics2D, n2, this.getControlPoints(true));
        graphics2D.setColor(Color.CYAN);
        n5 = 1;
        while (n5 < this.points.length - 1) {
            n = (int)(this.points[n5].x * (float)n2);
            int n6 = (int)(this.points[n5].y * (float)n2);
            if (this.dragIndex == n5) {
                graphics2D.fillOval(n2 + n - 3 + 1, n2 - n6 - 3 + 1, 5, 5);
            } else {
                graphics2D.drawOval(n2 + n - 3, n2 - n6 - 3, 6, 6);
            }
            ++n5;
        }
        graphics2D.translate(-insets.left, -insets.top);
    }

    private final JComponent createCurveComp() {
        JComponent jComponent = new JComponent(){

            public boolean isFocusTraversable() {
                return true;
            }

            public boolean isFocusable() {
                return true;
            }

            public boolean isFocusCycleRoot() {
                return true;
            }

            public void setEnabled(boolean bl) {
                this.setBorder(bl ? UIJInputConstants.CURVE_BORDER_ON : UIJInputConstants.CURVE_BORDER_OFF);
                super.setEnabled(bl);
            }

            public void paintComponent(Graphics graphics) {
                UIResponseCurve.this.render((Graphics2D)graphics, this);
            }
        };
        jComponent.setOpaque(true);
        jComponent.setEnabled(true);
        UIUtils.forceSquareSize(jComponent, this.radius * 2 + 1);
        this.chkEdit = new JCheckBox("Edit curve");
        this.cbPoints = new JComboBox<String>(new String[]{" 1 control point ", " 2 control points ", " 3 control points ", " 4 control points "});
        JPanel jPanel = new JPanel(new FlowLayout(1, 0, 0));
        jPanel.add(jComponent);
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 10));
        jPanel2.add((Component)this.chkEdit, "West");
        jPanel2.add((Component)this.cbPoints, "Center");
        this.panel = new JPanel(new BorderLayout(0, 10));
        this.panel.add((Component)jPanel2, "North");
        this.panel.add((Component)jPanel, "Center");
        return jComponent;
    }

    private Point2D.Float[] getControlPoints(boolean bl) {
        int n;
        Point2D.Float[] floatArray = this.workPoints;
        if (floatArray == null) {
            floatArray = new Point2D.Float[this.points.length + 2];
            n = this.points.length + 2;
            while (n-- > 0) {
                floatArray[n] = new Point2D.Float();
            }
            this.workPoints = floatArray;
        }
        int n2 = n = floatArray.length - 1;
        while (n2-- > 1) {
            floatArray[n2].x = (this.points[n2 - 1].x + 1.0f) / 2.0f;
            floatArray[n2].y = (this.points[n2 - 1].y + 1.0f) / 2.0f;
        }
        if (bl) {
            Point2D.Float float_ = floatArray[0];
            Point2D.Float float_2 = floatArray[n];
            float_.y = 0.0f;
            float_.x = 0.0f;
            float_2.y = 1.0f;
            float_2.x = 1.0f;
            CatmullRom.adjustTangent(float_, floatArray[2], floatArray[2], float_);
            CatmullRom.adjustTangent(floatArray[n - 2], float_2, floatArray[n - 2], float_2);
        }
        return floatArray;
    }

    public final void drawCubicCurve(Graphics2D graphics2D, int n, Point2D.Float[] floatArray) {
        float f;
        boolean bl = false;
        int n2 = 0;
        int n3 = 2 * n + 1;
        int n4 = 0;
        int n5 = 2 * n + 1;
        int n6 = floatArray.length;
        switch (n6) {
            case 5: {
                f = 0.05f;
                break;
            }
            case 6: {
                f = 0.075f;
                break;
            }
            case 7: {
                f = 0.1f;
                break;
            }
            default: {
                f = 0.125f;
            }
        }
        int n7 = 1;
        while (n7 < floatArray.length - 2) {
            float f2 = f;
            while (true) {
                UIResponseCurve.computeCatmullRom2(f2, floatArray, n7, this.workPoint);
                float f3 = this.workPoint.x;
                if (f3 < 0.0f) {
                    f3 = 0.0f;
                } else if (f3 > 2.0f) {
                    f3 = 2.0f;
                }
                float f4 = this.workPoint.y;
                if (f4 < 0.0f) {
                    f4 = 0.0f;
                } else if (f4 > 2.0f) {
                    f4 = 2.0f;
                }
                int n8 = (int)((float)n * f3);
                int n9 = 2 * n - (int)((float)n * f4);
                if (n8 < n2 || n9 > n3 || bl) {
                    graphics2D.setColor(UIJInputConstants.COLOR_CURVE_OFF);
                    graphics2D.drawLine(n4, n5, n8, n9);
                    graphics2D.setColor(UIJInputConstants.COLOR_CURVE_ON);
                }
                n4 = n8;
                n5 = n9;
                bl = false;
                if (n8 < n2) {
                    n8 = n2;
                    bl = true;
                }
                if (n9 > n3) {
                    n9 = n3;
                    bl = true;
                }
                graphics2D.drawLine(n2, n3, n8, n9);
                n2 = n8;
                n3 = n9;
                if (f2 >= 1.0f) break;
                float f5 = bl ? f / 2.0f : f;
                if (!((f2 += f5) > 1.0f)) continue;
                f2 = 1.0f;
            }
            ++n7;
        }
    }

    public static final void computeCatmullRom2(float f, Point2D.Float[] floatArray, int n, Point2D.Float float_) {
        float f2 = f * f;
        float f3 = f2 * f;
        float f4 = 2.0f * f2 - f3 - f;
        float f5 = 2.0f - 5.0f * f2 + 3.0f * f3;
        float f6 = f + 4.0f * f2 - 3.0f * f3;
        float f7 = f3 - f2;
        float_.x = f4 * floatArray[n - 1].x + f5 * floatArray[n].x + f6 * floatArray[n + 1].x + f7 * floatArray[n + 2].x;
        float_.y = f4 * floatArray[n - 1].y + f5 * floatArray[n].y + f6 * floatArray[n + 1].y + f7 * floatArray[n + 2].y;
    }
}

